IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[ADM_TABLE_EVENT_LOG]') 
					AND type in (N'U')) 
begin
--TRUNCATE TABLE ADM_TABLE_EVENT_LOG
--DROP TABLE ADM_TABLE_EVENT_LOG
CREATE TABLE ADM_TABLE_EVENT_LOG (

[ID]				BIGINT	 IDENTITY(1,1) PRIMARY KEY,
[HOSTNAME]			NVARCHAR(256)	DEFAULT HOST_NAME(),
[APPNAME]			NVARCHAR(256)	DEFAULT APP_NAME(),
[USERNAME]          NVARCHAR(256)	DEFAULT SUSER_NAME(),
[TABLENAME]			SYSNAME,
[OCCURS]			BIGINT	 DEFAULT 1	NOT NULL,
[OCCURSLAST]		DATETIME DEFAULT GETDATE() NOT NULL,
[COMMANDHASH]		VARBINARY(16)  NULL,
[COMMANDTEXT]		NVARCHAR(4000) NULL

)
end

/****** Object:  StoredProcedure [dbo].[SP_LOG_TABLE_EVENT]    Script Date: 04/30/2013 17:54:03 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SP_LOG_TABLE_EVENT]') AND type in (N'P', N'PC'))
DROP PROCEDURE SP_LOG_TABLE_EVENT

GO
--DROP PROCEDURE SP_LOG_TABLE_EVENT
CREATE PROCEDURE SP_LOG_TABLE_EVENT @TABLENAME SYSNAME
AS
BEGIN

DECLARE @COMMANDTEXT NVARCHAR(4000)
DECLARE @COMMANDHASH VARBINARY(16)
DECLARE @ID BIGINT

DECLARE @INPUTBUFFER TABLE (
        EVENTTYPE	NVARCHAR(30),
        PARAMETERS	INT,
        EVENTINFO	NVARCHAR(4000)
)

INSERT	@INPUTBUFFER
EXEC	sp_executesql N'DBCC INPUTBUFFER(@@spid) WITH NO_INFOMSGS'

SELECT	@COMMANDTEXT = EVENTINFO, 
		@COMMANDHASH = HASHBYTES('MD5',EVENTINFO)
FROM	@INPUTBUFFER

SELECT  @ID = ID 
FROM	ADM_TABLE_EVENT_LOG 
WHERE	TABLENAME	= @TABLENAME 
AND		COMMANDHASH = @COMMANDHASH
AND		USERNAME	= SUSER_NAME()
AND		HOSTNAME	= HOST_NAME()

IF @ID IS NULL
	INSERT INTO ADM_TABLE_EVENT_LOG 
	(TABLENAME,COMMANDHASH,COMMANDTEXT)
	VALUES
	(@TABLENAME,@COMMANDHASH,@COMMANDTEXT)
ELSE
	UPDATE	ADM_TABLE_EVENT_LOG
	SET		OCCURS = OCCURS + 1,OCCURSLAST = GETDATE()
	WHERE	ID = @ID
END
GO
/****** Object:  StoredProcedure [dbo].[SP_ENABLE_TABLE_EVENT_LOG]    Script Date: 04/30/2013 17:54:03 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SP_ENABLE_TABLE_EVENT_LOG]') AND type in (N'P', N'PC'))
DROP PROCEDURE SP_ENABLE_TABLE_EVENT_LOG
GO
--SP_ENABLE_TABLE_EVENT_LOG 'EST_PROD'
CREATE PROCEDURE SP_ENABLE_TABLE_EVENT_LOG @TABLENAME SYSNAME
AS
BEGIN
	DECLARE @OBJNAME SYSNAME
	SET @OBJNAME = 'TRG_'+@TABLENAME+'EVENT_LOG'
	IF OBJECT_ID(@OBJNAME) IS NULL
	BEGIN
		DECLARE @CREATE_TRIGGER NVARCHAR(1000)
		SET @CREATE_TRIGGER = N'CREATE TRIGGER '+@OBJNAME+' ON ' +@TABLENAME+' AFTER INSERT,UPDATE,DELETE AS BEGIN EXECUTE SP_LOG_TABLE_EVENT '''+@TABLENAME +'''END'
		EXECUTE SP_EXECUTESQL @CREATE_TRIGGER
	END
END

GO

/****** Object:  StoredProcedure [dbo].[SP_DISABLE_TABLE_EVENT_LOG]    Script Date: 04/30/2013 17:54:03 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SP_DISABLE_TABLE_EVENT_LOG]') AND type in (N'P', N'PC'))
DROP PROCEDURE SP_DISABLE_TABLE_EVENT_LOG
GO
--SP_DISABLE_TABLE_EVENT_LOG 'EST_PROD'
CREATE PROCEDURE SP_DISABLE_TABLE_EVENT_LOG @TABLENAME SYSNAME
AS
BEGIN
	DECLARE @OBJNAME SYSNAME
	SET @OBJNAME = 'TRG_'+@TABLENAME+'EVENT_LOG'
	IF OBJECT_ID(@OBJNAME) IS NOT NULL
	BEGIN
		DECLARE @DROP_TRIGGER NVARCHAR(1000)
		SET @DROP_TRIGGER = N'DROP TRIGGER '+@OBJNAME
		EXECUTE SP_EXECUTESQL @DROP_TRIGGER
	END
END